//
// Fragment Shader by WyldAnimal
// www.deskbabes.net
//
uniform float u_Elapsed; // same than iGlobalTime
uniform vec2 u_WindowSize; // same than iResolution 
uniform sampler2D texture1; // same than iChannel0 
 
// Visual Spectrum code for rainbow of colors
// Based on code by Spektre posted at http://stackoverflow.com/questions/3407942/rgb-values-of-visible-spectrum
// 
vec3 spectral_colour(float l) // RGB <0,1> <- lambda l <400,700> [nm]
{
	float r=0.0,g=0.0,b=0.0;
         if ((l>=400.0)&&(l<410.0)) { float t=(l-400.0)/(410.0-400.0); r=    +(0.33*t)-(0.20*t*t); }
    else if ((l>=410.0)&&(l<475.0)) { float t=(l-410.0)/(475.0-410.0); r=0.14         -(0.13*t*t); }
    else if ((l>=545.0)&&(l<595.0)) { float t=(l-545.0)/(595.0-545.0); r=    +(1.98*t)-(     t*t); }
    else if ((l>=595.0)&&(l<650.0)) { float t=(l-595.0)/(650.0-595.0); r=0.98+(0.06*t)-(0.40*t*t); }
    else if ((l>=650.0)&&(l<700.0)) { float t=(l-650.0)/(700.0-650.0); r=0.65-(0.84*t)+(0.20*t*t); }
         if ((l>=415.0)&&(l<475.0)) { float t=(l-415.0)/(475.0-415.0); g=             +(0.80*t*t); }
    else if ((l>=475.0)&&(l<590.0)) { float t=(l-475.0)/(590.0-475.0); g=0.8 +(0.76*t)-(0.80*t*t); }
    else if ((l>=585.0)&&(l<639.0)) { float t=(l-585.0)/(639.0-585.0); g=0.82-(0.80*t)           ; }
         if ((l>=400.0)&&(l<475.0)) { float t=(l-400.0)/(475.0-400.0); b=    +(2.20*t)-(1.50*t*t); }
    else if ((l>=475.0)&&(l<560.0)) { float t=(l-475.0)/(560.0-475.0); b=0.7 -(     t)+(0.30*t*t); }

	return vec3(r,g,b);
}

vec3 spectral_palette(float x) { return spectral_colour(x*300.0+400.0); }

// moving plasma of color
void main()
{
	//vec2 p=(0.2*gl_FragCoord.xy-u_WindowSize.xy)/max(u_WindowSize.x,u_WindowSize.y);
        //vec2 p=(0.02*gl_FragCoord.xy-u_WindowSize.xy)/max(u_WindowSize.x,u_WindowSize.y);
	  vec2 p=(3.2*gl_FragCoord.xy-u_WindowSize.xy)/max(u_WindowSize.x,u_WindowSize.y);
	for(int i=1;i<60;i++)
	{
		p=p+vec2(
			0.55/float(i)*cos(float(i)*p.y+.2*u_Elapsed+0.8*float(i))+1.0,
			0.35/float(i)*sin(float(i)*p.x+u_Elapsed+3.5*float(i))-3.4
			// try without use of float(i)
			//0.55/i*cos(i*p.y+.2*u_Elapsed+0.8*i)+1.0,
			//0.05/i*sin(i*p.x+u_Elapsed+3.5*i)-1.4
			
		);
	}
	vec3 col=spectral_palette(p.x-57.6);
	gl_FragColor=vec4(pow(col,vec3(1.0/2.2)),1.0);
        gl_FragColor.a = length(gl_FragColor.rgb); //renders alpha transparency
}
